﻿//////////////////////////////////////////////
// ComponentUtils.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkImages
{
	class Image ;
}

namespace nkWinUi
{
	class Component ;
	class Font ;
}

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

// nkMaths
#include <NilkinsMaths/Geometry/Point.h>
#include <NilkinsMaths/Geometry/Rectangle.h>

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>
#include <NilkinsMemory/Containers/BufferView.h>
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT ComponentUtils
	{
		public :

			// Constructeur, destructeur
			ComponentUtils () noexcept ;
			virtual ~ComponentUtils () ;

			// Fonctions utilitaires à refaire pour automatiser au maximum dans la classe Component
			// Dimensions
			virtual nkMaths::Rectangle getComponentSize (const Component* component) = 0 ;
			virtual nkMaths::Rectangle getScreenDimensions () = 0 ;

			// Conversions
			virtual nkMaths::Point getComponentCoordFromScreenCoord (const Component* component, nkMaths::Point screenCoord) = 0 ;
			virtual nkMaths::Point getScreenCoordFromComponentCoord (const Component* component, nkMaths::Point componentCoord) = 0 ;

			// Positioning
			virtual nkMaths::Rectangle getComponentDimensions (const Component* component) = 0 ;
			virtual void setComponentPosition (Component* component, float x, float y) = 0 ;
			virtual void setComponentSize (Component* component, float width, float height) = 0 ;
			virtual void setComponentDimensions (Component* component, float x, float y, float width, float height) = 0 ;

			// Visibility
			virtual bool getComponentVisibility (const Component* component) = 0 ;
			virtual void setComponentVisibility (Component* component, bool visibleOrNot) = 0 ;

			// Enabling
			virtual bool isComponentEnabled (const Component* component) = 0 ;
			virtual void setComponentEnabled (Component* component, bool enabledOrNot) = 0 ;

			// Focus
			virtual void setComponentFocus (Component* component) = 0 ;

			// Hiérarchie
			virtual bool isComponentInForeground (const Component* component) = 0 ;
			virtual void setComponentInForeground (Component* component) = 0 ;

			// Label
			virtual void setComponentLabel (Component* component, nkMemory::StringView label) = 0 ;

			// Update
			virtual void updateComponent (Component* component) = 0 ;
			virtual void freezeComponentPainting (Component* component, bool value) = 0 ;

			// Images
			virtual nkImages::Image paintToImage (Component* component, bool withFrame) = 0 ;

			// Cursor
			virtual nkMaths::Point getCursorPosition () = 0 ;
			virtual void setCursorPosition (nkMaths::Point absPos) = 0 ;

			// Fonts
			virtual nkMemory::BufferCast<nkMemory::String> getAvailableFontFaces () = 0 ;
			virtual nkMemory::BufferCast<unsigned int> getCharactersWidth (nkMemory::BufferView<char> characters, Font* font) = 0 ;
	} ;
}